%------------------------------------------------------------------------------
% File     : NUM793^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 87d
% Version  : Especial.
% English  : more x0 z0

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz87d [Lan30]
%          : satz51d [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 0.00 v5.3.0, 0.25 v5.2.0, 0.00 v3.7.0
% Syntax   : Number of formulae    :   15 (   0 unit;   8 type;   0 defn)
%            Number of atoms       :   36 (   0 equality;  18 variable)
%            Maximal formula depth :    8 (   4 average)
%            Number of connectives :   29 (   0   ~;   0   |;   0   &;  24   @)
%                                         (   0 <=>;   5  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    8 (   8   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   10 (   8   :;   0   =)
%            Number of variables   :    9 (   0 sgn;   9   !;   0   ?;   0   ^)
%                                         (   9   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(rat_type,type,(
    rat: $tType )).

thf(x0,type,(
    x0: rat )).

thf(y0,type,(
    y0: rat )).

thf(z0,type,(
    z0: rat )).

thf(more,type,(
    more: rat > rat > $o )).

thf(m,axiom,
    ( more @ x0 @ y0 )).

thf(moreis,type,(
    moreis: rat > rat > $o )).

thf(n,axiom,
    ( moreis @ y0 @ z0 )).

thf(less,type,(
    less: rat > rat > $o )).

thf(satz83,axiom,(
    ! [Xx0: rat,Xy0: rat] :
      ( ( less @ Xx0 @ Xy0 )
     => ( more @ Xy0 @ Xx0 ) ) )).

thf(lessis,type,(
    lessis: rat > rat > $o )).

thf(satz87a,axiom,(
    ! [Xx0: rat,Xy0: rat,Xz0: rat] :
      ( ( lessis @ Xx0 @ Xy0 )
     => ( ( less @ Xy0 @ Xz0 )
       => ( less @ Xx0 @ Xz0 ) ) ) )).

thf(satz84,axiom,(
    ! [Xx0: rat,Xy0: rat] :
      ( ( moreis @ Xx0 @ Xy0 )
     => ( lessis @ Xy0 @ Xx0 ) ) )).

thf(satz82,axiom,(
    ! [Xx0: rat,Xy0: rat] :
      ( ( more @ Xx0 @ Xy0 )
     => ( less @ Xy0 @ Xx0 ) ) )).

thf(satz87d,conjecture,
    ( more @ x0 @ z0 )).

%------------------------------------------------------------------------------
